// utility object.
CUtility	= {};

// recursive file search.
function CUtility:recursiveFileList( path, done, files, itemformat )
	// this path already done?
	if( table.HasValue( done, path ) ) then return; end
	
	// add to done list.
	table.insert( done, path );
	
	// fetch files
	local filelist = file.Find( path .. "/*.*" );

	// iterate it.
	local filename;
	for _, filename in pairs( filelist ) do
		// ignore current and prev dirs.
		if( filename != "." && filename != ".." ) then
			
			// file or dir?
			if( file.IsDir( path .. "/" .. filename ) ) then
				// search subdir.
				self:recursiveFileList( path .. "/" .. filename, done, files, itemformat );
				
			else
				// add file.
				if( !itemformat ) then
					table.insert( files, path .. "/" .. filename );
					
				else
					table.insert( files, { filename = path .. "/" .. filename } );
					
				end
				
			end
			
		end
		
	end
	
end


// Fixup vector.
function CUtility:FixupVector( targetposition, targetrotation, position, ofs, normal, surface_align )
	// calculate distance
	local dist = position:Length();
	
	// calculate direction
	local dir = position:GetNormal();
	
	
	// calculate directions.
	local pitch = Vector( 0, 1, 0 );
	local yaw = Vector( 0, 0, 1 );
	local roll = Vector( 1, 0, 0 );
	
	
	// calculate offset.
	local offset = ofs;
	if( normal ) then
		// calcualte offset from normal.
		offset = ( yaw * ofs.z ) + ( roll * ofs.x ) + ( pitch * -ofs.y );
	
	end
	
	
	// rotate it!
	local angles = dir:Angle();
	
	// normal?
	if( normal ) then
		angles:RotateAroundAxis( pitch, surface_align.p );
		angles:RotateAroundAxis( yaw, surface_align.y );
		angles:RotateAroundAxis( roll, surface_align.r );
		
	end
	
	// convert to normal space
	if( normal ) then pitch = normal:Angle():Right(); end
	if( normal ) then yaw = normal; end
	if( normal ) then roll = normal:Angle():Up(); end
	
	// final rotation.
	angles:RotateAroundAxis( pitch, targetrotation.p );
	angles:RotateAroundAxis( yaw, targetrotation.y );
	angles:RotateAroundAxis( roll, targetrotation.r );
	
	// convert back
	dir = angles:Forward();
	
	// transform
	return targetposition + ( dir * dist ) + offset;
	
end

// Fixup angle.
function CUtility:FixupAngle( currentangle, targetrotation, normal, surface_align )
	// calculate directions.
	local pitch = Vector( 0, 1, 0 );
	local yaw = Vector( 0, 0, 1 );
	local roll = Vector( 1, 0, 0 );
	
	// rotate angle
	local angles = Angle( currentangle.x, currentangle.y, currentangle.z );
	
	// align to surface?
	if( normal ) then
		angles:RotateAroundAxis( pitch, surface_align.p );
		angles:RotateAroundAxis( yaw, surface_align.y );
		angles:RotateAroundAxis( roll, surface_align.r );
		
	end
	
	// convert to normal space
	if( normal ) then pitch = normal:Angle():Right(); end
	if( normal ) then yaw = normal; end
	if( normal ) then roll = normal:Angle():Up(); end
	
	// final rotation.
	angles:RotateAroundAxis( pitch, targetrotation.p );
	angles:RotateAroundAxis( yaw, targetrotation.y );
	angles:RotateAroundAxis( roll, targetrotation.r );
	
	return angles;
	
end

// string to vec.
function CUtility:StringToVector( s )
	local tbl = string.Explode( " ", s );
	return Vector( tonumber( tbl[1] ), tonumber( tbl[2] ), tonumber( tbl[3] ) );
	
end

// string to ang.
function CUtility:StringToAngle( s )
	local tbl = string.Explode( " ", s );
	return Angle( tonumber( tbl[1] ), tonumber( tbl[2] ), tonumber( tbl[3] ) );
	
end

// string to ang.
function CUtility:StringToColor( s )
	local tbl = string.Explode( " ", s );
	return Color( tonumber( tbl[1] ), tonumber( tbl[2] ), tonumber( tbl[3] ), tonumber( tbl[4] or "255" ) );
	
end

if( SERVER ) then
	// calc elastic strengths
	function CUtility:CalcElasticConsts( phys1, phys2, ent1, ent2, fixed )
		local minMass = 0;
		
		if ( ent1:IsWorld() ) then minMass = phys2:GetMass();
		elseif ( ent2:IsWorld() ) then minMass = phys1:GetMass();
		else 
			minMass = math.min( phys1:GetMass(), phys2:GetMass() );
			
		end
		
		// const, damp
		local const = minMass * 100;
		local damp = const * 0.2;
		
		if ( fixed == 0 ) then
			const = minMass * 50;
			damp = const * 0.1;
			
		end
		
		return const, damp;
		
	end
	
end

if( SERVER ) then
	// test something
	function CC_Waffle( )
		local files = {};
		CUtility:recursiveFileList( "../vmf/server", {}, files, false );
		
		// parse files..
		local filename;
		for _, filename in pairs( files ) do
			// create new vmf
			local vmf = VMFSuite.VMF();
			
			// parse the vmf data.
			vmf:Parse( file.Read( filename ) );
			
			print( "VMF - " .. vmf:EntityCount() );
			
		end
	
	end
	concommand.Add( "waffle_vmf", CC_Waffle );
	
end
